% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mapping.R
\name{Bowtie2Mapping}
\alias{Bowtie2Mapping}
\alias{atacBowtie2Mapping,ATACProc-method}
\alias{atacBowtie2Mapping}
\alias{bowtie2Mapping}
\title{Use bowtie2 aligner to map reads to reference genome}
\usage{
atacBowtie2Mapping(
  atacProc,
  samOutput = NULL,
  reportOutput = NULL,
  bt2Idx = NULL,
  fastqInput1 = NULL,
  fastqInput2 = NULL,
  interleave = FALSE,
  threads = getThreads(),
  paramList = "--no-discordant --no-unal --no-mixed -X 2000",
  ...
)

\S4method{atacBowtie2Mapping}{ATACProc}(
  atacProc,
  samOutput = NULL,
  reportOutput = NULL,
  bt2Idx = NULL,
  fastqInput1 = NULL,
  fastqInput2 = NULL,
  interleave = FALSE,
  threads = getThreads(),
  paramList = "--no-discordant --no-unal --no-mixed -X 2000",
  ...
)

bowtie2Mapping(
  fastqInput1,
  fastqInput2 = NULL,
  samOutput = NULL,
  reportOutput = NULL,
  bt2Idx = NULL,
  interleave = FALSE,
  threads = getThreads(),
  paramList = "--no-discordant --no-unal --no-mixed -X 2000",
  ...
)
}
\arguments{
\item{atacProc}{\code{\link{ATACProc-class}} object scalar.
It has to be the return value of upstream process:
\code{\link{atacRemoveAdapter}}
\code{\link{removeAdapter}}}

\item{samOutput}{\code{Character} scalar.
A path to a SAM file
used for the alignment output.}

\item{reportOutput}{\code{Character} scalar.
The prefix of report files path.}

\item{bt2Idx}{\code{Character} scalar.
bowtie2 index files
prefix: 'dir/basename'
(minus trailing '.*.bt2' of 'dir/basename.*.bt2').}

\item{fastqInput1}{\code{Character} vector. For single-end sequencing,
it contains sequence file paths.
For paired-end sequencing, it can be file paths with #1 mates
paired with file paths in fastqInput2.
And it can also be interleaved file paths when argument
interleaved=\code{TRUE}}

\item{fastqInput2}{\code{Character} vector. It contains file paths with
#2 mates paired with file paths in fastqInput1.
For single-end sequencing files and interleaved paired-end
sequencing files(argument interleaved=\code{TRUE}),
it must be \code{NULL}.}

\item{interleave}{\code{Logical}. Set \code{TRUE} when files are
interleaved paired-end sequencing data.}

\item{threads}{\code{Integer} scalar.
The threads will be created in this process. default: getThreads()}

\item{paramList}{Additional arguments to be passed on to the binaries.
See below for details.}

\item{...}{Additional arguments, currently unused.}
}
\value{
An invisible \code{\link{ATACProc-class}} object scalar for downstream analysis.
}
\description{
Use bowtie2 aligner to map reads to reference genome
}
\details{
The parameter related to input and output file path
will be automatically
obtained from \code{\link{ATACProc-class}} object(\code{atacProc}) or
generated based on known parameters
if their values are default(e.g. \code{NULL}).
Otherwise, the generated values will be overwrited.
If you want to use this function independently,
you can use \code{bowtie2Mapping} instead.
additional parameters to be passed on to
bowtie2. You can put all aditional
arguments in one \code{Character}(e.g. "--threads 8 --no-mixed")
with white space splited just like command line,
or put them as \code{Character} vector
(e.g. c("--threads","8","--no-mixed")). Note that some
arguments("-x","--interleaved","-U","-1","-2","-S","threads") to the
bowtie2 are invalid if they are already handled as explicit
function arguments. See the output of
\code{bowtie2_usage()} for details about available parameters.
}
\examples{
td <- tempdir()
setTmpDir(td)

## Building a bowtie2 index
library("Rbowtie2")
refs <- dir(system.file(package="esATAC", "extdata", "bt2","refs"),
full=TRUE)
bowtie2_build(references=refs, bt2Index=file.path(td, "lambda_virus"),
"--threads 4 --quiet",overwrite=TRUE)
## Alignments
reads_1 <- system.file(package="esATAC", "extdata", "bt2", "reads",
"reads_1.fastq")
reads_2 <- system.file(package="esATAC", "extdata", "bt2", "reads",
"reads_2.fastq")
if(file.exists(file.path(td, "lambda_virus.1.bt2"))){
    (bowtie2Mapping(bt2Idx = file.path(td, "lambda_virus"),
       samOutput = file.path(td, "result.sam"),
       fastqInput1=reads_1,fastqInput2=reads_2,threads=3))
    head(readLines(file.path(td, "result.sam")))
}
}
\seealso{
\code{\link{atacRemoveAdapter}}
\code{\link{removeAdapter}}
\code{\link{bowtie2}}
\code{\link{bowtie2_build}}
\code{\link{bowtie2_usage}}
\code{\link{atacSam2Bam}}
\code{\link{atacSamToBed}}
\code{\link{atacLibComplexQC}}
}
\author{
Zheng Wei
}
