% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erccROC.R
\name{erccROC}
\alias{erccROC}
\title{Produce Receiver Operator Characteristic (ROC) Curves and AUC statistics}
\usage{
erccROC(exDat)
}
\arguments{
\item{exDat}{list, contains input data and stores analysis results}
}
\description{
Produce Receiver Operator Characteristic (ROC) Curves and AUC statistics
}
\examples{

data(SEQC.Example)

exDat <- initDat(datType="array", isNorm=FALSE, 
                 exTable=UHRR.HBRR.arrayDat,
                 filenameRoot="testRun", sample1Name="UHRR",
                 sample2Name="HBRR", erccmix="RatioPair", 
                 erccdilution = 1, spikeVol = 50, 
                 totalRNAmass = 2.5*10^(3), choseFDR=0.01)
                 
exDat <- est_r_m(exDat)
                  
exDat <- dynRangePlot(exDat)

exDat <- geneExprTest(exDat)

exDat <- erccROC(exDat)

exDat$Figures$rocPlot

}
