% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setStandalone.R
\name{setStandalone}
\alias{setStandalone}
\title{Set settings for epiviz standalone repository.}
\usage{
setStandalone(
  url = "https://github.com/epiviz/epiviz.git",
  branch = "min",
  local_path = NULL,
  non_interactive = FALSE
)
}
\arguments{
\item{url}{(character) github url to use. defaults to (\url{"https://github.com/epiviz/epiviz.git"}).}

\item{branch}{(character) branch on the github repository. defaults to (master).}

\item{local_path}{(character) if you already have a local instance of epiviz and would like to run standalone use this.}

\item{non_interactive}{(logical) don't download repo, used for testing purposes.}
}
\value{
path to the epiviz app git repository
}
\description{
The epiviz app run by function \code{\link{startStandalone}} in this package
is cloned as a git repository. This function intializes the settings specifying
which git repository is used. It can be either a github repository (the usual case), 
or local repository containing the epiviz JS app (used for testing and development).
}
\examples{
# argument non_interactive here to avoid downloading when testing
# package. Remove non_interactive argument when you try it out.
setStandalone(url="https://github.com/epiviz/epiviz.git", branch="master", non_interactive=TRUE)

}
