% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EpivizServer-class.R
\docType{class}
\name{EpivizServer-class}
\alias{EpivizServer-class}
\alias{EpivizServer}
\title{Class providing WebSocket connection server}
\value{
RC object with methods for communication with epiviz JS app
}
\description{
Class providing WebSocket connection server
}
\details{
The most important aspect of the API of this server are methods \code{register_action} and \code{send_request}. These are
used to interact with the epiviz JS app through the provided websocket connection. \code{register_action(action, callback)} registers
a callback function to be executed upon request from the epiviz JS app. When the server receives a JSON message through the websocket, it
checks for an \code{action} field in the received request message, and then evaluates the expression \code{callback(message_data)} where \code{message_data}
is obtained from the \code{data} field in the received message. A response will be sent to the epiviz app with field \code{data} populated
with the result of the callback. If an error occurs during evaluation of the callback function, the response will be sent with field
\code{success} set to \code{false}.

To send requests to the JS app, method \code{send_request(request_data, callback)} should be used. This is sends a request to the JS app
with the \code{data} field populated with argument \code{request_data}. Once a response is received (with field \code{success} equal to \code{true})
the expression \code{callback(response_data)} is evaluated where \code{response_data} is obtained from the \code{data} field in the received
response message.
}
\section{Methods}{

\describe{
\item{\code{has_action(action)}}{Check if a callback is registered for given action<character>, <logical>. (See Details)}

\item{\code{has_request_waiting()}}{Check if there is a sent request waiting for a response from JS app, <logical>}

\item{\code{is_closed()}}{Check if server is closed, <logical>}

\item{\code{is_daemonized()}}{Check if server is running in background, <logical>}

\item{\code{is_interactive()}}{Check if server is running in interactive mode, <logical>}

\item{\code{is_socket_connected()}}{Check if there is an open websocket connection to JS app, <logical>}

\item{\code{register_action(action, callback)}}{Register a callback<function> to evaluate when epiviz JS sends a request for given action<character>. (See Details)}

\item{\code{run_server(...)}}{Run server in blocking mode}

\item{\code{send_request(request_data, callback)}}{Send request to epiviz JS app with given request_data<list>, and evaluate callback<function> when response arrives. (See Details)}

\item{\code{service()}}{Listen to requests from server. Only has effect when non-daemonized}

\item{\code{start_server()}}{Start the underlying httpuv server, daemonized if applicable}

\item{\code{stop_server()}}{Stop the underlying httpuv server}

\item{\code{stop_service()}}{Stop listenning to requests from server. Only has effect when non-daemonized.}

\item{\code{unregister_action(action)}}{Unregister a callback function for given action<character> (if registered). (See Details)}

\item{\code{wait_to_clear_requests(timeout = 3L)}}{Wait for \code{timeout} seconds to clear all pending requests.}
}}

\examples{
server <- createServer()
server$register_action("getData", function(request_data) {
  list(x=1,y=3)
})

server$start_server()

server$send_request(list(x=2,y=5), function(response_data) {
  cat(response_data$x)
})

server$stop_server()
}
