% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EpivizData-class.R
\docType{class}
\name{EpivizData-class}
\alias{EpivizData-class}
\alias{EpivizData}
\title{Data container for epiviz data server}
\description{
Data container for epiviz data server
}
\section{Methods}{

\describe{
\item{\code{get_default_chart_type()}}{Get name of default chart type for this data type}

\item{\code{get_id()}}{Get id provided by manager \code{\link{EpivizDataMgr-class}}}

\item{\code{get_measurements()}}{Get description of measurements served by this object}

\item{\code{get_name()}}{Get datasource name, usually set by manager \code{\link{EpivizDataMgr-class}}}

\item{\code{get_rows(query, metadata, useOffset = FALSE)}}{Get genomic interval information overlapping query <\code{\link{GenomicRanges}}> region}

\item{\code{get_source_name()}}{Get original datasource name provided by manager \code{\link{EpivizDataMgr-class}}}

\item{\code{get_values(query, measurement, round = TRUE)}}{Get measurement values for features overlapping query region <\code{\link{GenomicRanges}}}

\item{\code{parse_measurement(ms_id = NULL)}}{Parse a measurement description for data served by this object}

\item{\code{set_id(id)}}{Set id, used by manager \code{\link{EpivizDataMgr-class}}}

\item{\code{set_limits(ylim)}}{Set plotting limits for continuous data}

\item{\code{set_mgr(mgr)}}{Set data manager, \code{\link{EpivizDataMgr-class}}}

\item{\code{set_name(name)}}{Set datasource name, usually set by manager \code{\link{EpivizDataMgr-class}}}

\item{\code{set_source_name(source_name)}}{Set original datasource name, used by manager \code{\link{EpivizDataMgr-class}}}

\item{\code{toMySQL(connection, db_name, annotation = NULL, batch = 50, index = TRUE)}}{Send EpivizData to a MySQL Database
\describe{
\item{connection}{DBIConnection to a database}
\item{db_name}{Name of MySQL database}
\item{annotation}{Annotation for index table}
\item{batch}{Batch size for data sent to the MySQL database}
\item{index}{Insert into respective index table}
}}

\item{\code{update(new_object, send_request = TRUE)}}{Update underlying data object with new object}
}}

