% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epi_mahdist.R
\name{res_mahdist}
\alias{res_mahdist}
\title{Creates a data frame containing the results
obtained from Robust Mahalanobis distance}
\usage{
res_mahdist(case, bump, outliers)
}
\arguments{
\item{case}{a character string specifying the case sample name.}

\item{bump}{a DMR obtained from \link[bumphunter]{bumphunter}
(i.e. a row from \link[bumphunter]{bumphunter} method result).}

\item{outliers}{the robust distance computed by
\link[epimutacions]{epi_mahdist} function results.}
}
\value{
The function returns a data frame containing
the following information for each DMR:
\itemize{
\item genomic ranges
\item DMR base pairs
\item number and name of CpGs in DMR
\item statistics:
\itemize{
\item Outlier score
\item Outlier significance
\item Outlier direction
}
\item Sample name
}

For more information about the output see
\link[epimutacions]{epimutations}.
}
\description{
Creates a data frame containing the
genomic regions, statistics and direction for the DMRs.
}
