% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlmtst.R
\name{mlmtst}
\alias{mlmtst}
\title{Sums of Squares and Pseudo-F Statistics from a Multivariate Fit}
\usage{
mlmtst(fit, X, subset = NULL, tol = 0.001)
}
\arguments{
\item{fit}{multivariate fit obtained by \code{\link{lm}}.}

\item{X}{design matrix obtained by \code{\link{model.matrix}}.}

\item{subset}{subset of predictors for which summary
statistics will be reported.
Note that this is different from the
"\code{subset}" argument in \code{\link{lm}}.}

\item{tol}{\code{e[e/sum(e) > tol]}, where \code{e}
is the vector of eigenvalues
of the residual covariance matrix.
Required to prevent long running times of
algorithm AS 204. Default is 0.001 to
ensure minimal loss of accuracy.}
}
\value{
A list containing:
\item{SS}{sums of squares for all predictors (and residuals).}
\item{df}{degrees of freedom for all predictors (and residuals).}
\item{f.tilde}{pseudo-F statistics for all predictors.}
\item{r2}{partial R-squared for all predictors.}
\item{e}{eigenvalues of the residual covariance matrix.}
}
\description{
Computes the sum of squares,
degrees of freedom, pseudo-F statistics and
partial R-squared for
each predictor from a multivariate \code{fit}.
It also returns the eigenvalues of
the residual covariance matrix.
}
\details{
Different types of sums of squares
(i.e. "\code{I}", "\code{II}" and
"\code{III}") are available.
}
\seealso{
\code{\link{AS204}}
}
\author{
Diego Garrido-Martín
}
\keyword{internal}
