% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{maxStepProb}
\alias{maxStepProb}
\title{M-step (maximization w.r.t. initial and transition probabilities)}
\usage{
maxStepProb(hdf5)
}
\arguments{
\item{hdf5}{path to where the hdf5 is saved}
}
\description{
M-step (maximization w.r.t. initial and transition probabilities)
}
\examples{
#Creating dummy object
countData <- rbind(matrix(rnbinom(1e3,mu = 2,size = 10),ncol = 1),
                  matrix(rnbinom(2e3,mu = 7.5,size = 5),ncol = 1),
                  matrix(rnbinom(1e3,mu = 2,size = 10),ncol = 1))



colData <- data.frame(condition = 'A', replicate = 1)
object <- epigraHMMDataSetFromMatrix(countData,colData)

#Initializing
object <- initializer(object,controlEM())

#Running epigraHMM
object <- epigraHMM(object,controlEM(),type = 'consensus',dist = 'nb')

#Example
maxStepProb(hdf5 = S4Vectors::metadata(object)$output)
}
