% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controlEM.R
\name{controlEM}
\alias{controlEM}
\title{Control parameters for the EM algorithm from epigraHMM}
\usage{
controlEM(
  epsilonEM = c(MRCPE = 0.001, MACPE = 0.001, ARCEL = 0.001),
  maxIterEM = 500,
  minIterEM = 3,
  gapIterEM = 3,
  maxCountEM = 3,
  maxDisp = 1000,
  criterion = "all",
  minZero = .Machine$double.xmin,
  probCut = 0.05,
  quiet = TRUE,
  maxIterInnerEM = 5,
  epsilonInnerEM = 0.001,
  trimOffset = 3,
  pattern = NULL,
  tempDir = tempdir(),
  fileName = "epigraHMM",
  pruningThreshold = NULL,
  quietPruning = TRUE
)
}
\arguments{
\item{epsilonEM}{a named vector of positive values specifying up to four possible convergence criterion tolerances for the EM algorithm (see 'criterion' below). Default is c('MRCPE' = 1e-3, 'MACPE' = 1e-3,'ARCEL' = 1e-3).}

\item{maxIterEM}{a positive integer giving the maximum number of EM iterations. Default is 500.}

\item{minIterEM}{a positive integer giving the minimum number of EM iterations to start evaluating the convergence. Default is 3.}

\item{gapIterEM}{a positive integer giving the number of EM iterations apart to compute the convergence criterion. Default is 3.}

\item{maxCountEM}{a positive integer giving the number of consecutive EM iterations satisfying the convergence criterion in order to stop the algorithm. Default is 3.}

\item{maxDisp}{a positive value for the upper limit constraint of the dispersion parameters. Default is 1000.}

\item{criterion}{a character specifying the convergence criterion. Either "MRCPE" (maximum absolute relative change in parameter estimates), "MACPE" (maximum absolute change of parameter estimates),
"ARCEL" (absolute relative change of the Q-function), or "all" (simultaneously check for MRCPE, MACPE, and ARCEL). Default is "all".}

\item{minZero}{a positive value for the minimum positive value allowed in computations to avoid having zeros. Default is .Machine$double.xmin.}

\item{probCut}{a number between 0 and 1 for the cutoff of the rejection controlled EM algorithm. Default 0.05.}

\item{quiet}{a logical indicating whether to print messages. Default is TRUE.}

\item{maxIterInnerEM}{a positive integer giving the maximum number of inner EM iterations. Default is 5.}

\item{epsilonInnerEM}{a positive value with the convergence tolerance value for the inner EM algorithm. The criterion for the inner EM is "MRCPE". Default is 1e-3.}

\item{trimOffset}{either NULL or a positive integer indicating the number of decimal places to be used in the offset. Default is 3.}

\item{pattern}{either NULL (the default) or a list with length equal to the number of differential patterns to be modeled by the differential HMM state. See Details section below.}

\item{tempDir}{a string where results will be saved. Default is `tempdir()`.}

\item{fileName}{a string with the name of the result files. Default is `epigraHMM`.}

\item{pruningThreshold}{a numeric value between 0 and 1 to consider when pruning rare combinatorial patterns. Default is NULL (see Details).}

\item{quietPruning}{a logical indicating whether to print messages during the pruning step. Default is TRUE.}
}
\value{
A list with components equal to the arguments
}
\description{
This function passes controlling parameters for the EM algorithm implemented in the epigraHMM package.
}
\details{
If \code{pattern} is NULL, every possible combinatorial pattern will be considered. If \code{pattern} is a list, elements of it should specify the differential patterns to be modeled by each mixture component.
For instance, if pattern = list(2,c(1,3)) the mixture model will have two components that will represent the enrichment of condition 2 alone and the enrichment of conditions 1 and 3 together.

If \code{pruningThreshold} is a value between 0 and 1, say 0.05, epigraHMM 
will sequentially remove differential combinatorial patterns of enrichment 
from any mixture model component with associated posterior mixture proportion
less than 0.05.
}
\examples{
# No more than 100 EM iterations
control <- controlEM(maxIterEM = 100)

}
\references{
\url{https://github.com/plbaldoni/epigraHMM}
}
\author{
Pedro L. Baldoni, \email{pedrobaldoni@gmail.com}
}
