% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/deFit-methods.R, R/deSet-methods.R
\docType{methods}
\name{show}
\alias{show}
\alias{show,deFit-method}
\alias{show,deSet-method}
\title{Show function for deFit and deSet}
\usage{
show(object)

\S4method{show}{deFit}(object)

\S4method{show}{deSet}(object)
}
\arguments{
\item{object}{\code{S4 object}: \code{\linkS4class{deSet}}}

}
\value{
Nothing of interest
}
\description{
Show function for \code{\linkS4class{deFit}} and \code{\linkS4class{deSet}}
objects.
}
\examples{
# import data
library(splines)
data(kidney)
age <- kidney$age
sex <- kidney$sex
kidexpr <- kidney$kidexpr
cov <- data.frame(sex = sex, age = age)

# create models
null_model <- ~sex
full_model <- ~sex + ns(age, df = 4)

# create deSet object from data
de_obj <- build_models(data = kidexpr, cov = cov, null.model = null_model,
full.model = full_model)

# get summary
summary(de_obj)

# run odp and summarize
de_odp <- odp(de_obj, bs.its= 20)
de_odp
}
\author{
John Storey, Andrew Bass
}

