% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/getMethods.R
\docType{methods}
\name{sType}
\alias{sType}
\alias{sType,deFit-method}
\title{Statistic type used in analysis}
\usage{
sType(object)

\S4method{sType}{deFit}(object)
}
\arguments{
\item{object}{\code{S4 object}: \code{\linkS4class{deFit}}}
}
\value{
\code{sType} returns the statistic type- either "odp" or "lrt".
}
\description{
Access the statistic type in a \code{\linkS4class{deFit}} object. Can
either be the optimal discovery procedure (odp) or the likelihood ratio
test (lrt).
}
\examples{
# import data
library(splines)
data(kidney)
age <- kidney$age
sex <- kidney$sex
kidexpr <- kidney$kidexpr
cov <- data.frame(sex = sex, age = age)

# create models
null_model <- ~sex
full_model <- ~sex + ns(age, df = 4)

# create deSet object from data
de_obj <- build_models(data = kidexpr, cov = cov, null.model = null_model,
full.model = full_model)

# run fit_models to get model fits
de_fit <- fit_models(de_obj)

# extract the statistic type of model fits
stat_type <- sType(de_fit)

}
\author{
John Storey, Andrew Bass
}
\seealso{
\code{\link{fit_models}}, \code{\linkS4class{deFit}} and
\code{\linkS4class{deSet}}
}
\keyword{sType}

