% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/getMethods.R
\docType{methods}
\name{resNull}
\alias{resNull}
\alias{resNull,deFit-method}
\title{Residuals of null model fit}
\usage{
resNull(object)

\S4method{resNull}{deFit}(object)
}
\arguments{
\item{object}{\code{S4 object}: \code{\linkS4class{deFit}}}
}
\value{
\code{resNull} returns a matrix of residuals from null model.
}
\description{
Access the fitted null model residuals in an \code{\linkS4class{deFit}}
object.
}
\examples{
# import data
library(splines)
data(kidney)
age <- kidney$age
sex <- kidney$sex
kidexpr <- kidney$kidexpr
cov <- data.frame(sex = sex, age = age)

# create models
null_model <- ~sex
full_model <- ~sex + ns(age, df = 4)

# create deSet object from data
de_obj <- build_models(data = kidexpr, cov = cov, null.model = null_model,
full.model = full_model)

# run fit_models to get model fits
de_fit <- fit_models(de_obj)

# extract out the null residuals from the model fits
res_null <- resNull(de_fit)
}
\author{
John Storey, Andrew Bass
}
\seealso{
\code{\link{fit_models}}
}

