% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edge.R
\docType{data}
\name{kidney}
\alias{kidney}
\title{Gene expression dataset from Rodwell et al. (2004)}
\format{\itemize{
  \item kidcov: A 133 rows by 6 columns data frame detailing the study
  design.
  \item kidexpr: A 500 rows by 133 columns matrix of gene expression values,
  where each row corresponds to a different probe-set and each column to a
  different tissue sample.
  \item age: A vector of length 133 giving the age of each sample.
  \item sex: A vector of length 133 giving the sex of each sample.
}}
\usage{
data(kidney)
}
\value{
kidney dataset
}
\description{
Gene expression measurements from kidney samples were obtained from 72
human subjects ranging in age from 27 to 92 years. Only one array was
obtained per individual, and the age and sex of each individual were
recorded.
}
\note{
These data are a random subset of 500 probe-sets from the total number of 
probe-sets in the original data set. To download the full data set, go to 
\url{http://genomine.org/edge/}. The \code{age} and \code{sex} are contained
in \code{kidcov} data frame.
}
\examples{
# import data
data(kidney)
sex <- kidney$sex
age <- kidney$age
kidexpr <- kidney$kidexpr

# create model
de_obj <- build_study(data = kidexpr, adj.var = sex, tme = age,
sampling = "timecourse", basis.df = 4)

# use the ODP/lrt method to determine significant genes
de_odp <- odp(de_obj, bs.its=10)
de_lrt <- lrt(de_obj, nullDistn = "bootstrap", bs.its = 10)

# summarize significance results
summary(de_odp)
}
\references{
Storey JD, Xiao W, Leek JT, Tompkins RG, and Davis RW. (2005) Significance
analysis of time course microarray experiments. PNAS, 102: 12837-12842. \cr
\url{http://www.pnas.org/content/100/16/9440.full}
}
\keyword{datasets}

