% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edge.R
\docType{data}
\name{gibson}
\alias{gibson}
\title{Gene expression dataset from Idaghdour et al. (2008)}
\format{\itemize{
  \item batch: Batches in experiment.
  \item location: Environment/lifestyle of Moroccan Amazigh groups.
  \item gender: Sex of individuals.
  \item gibexpr: A 500 rows by 46 columns matrix of gene expression values.
}}
\usage{
data(gibson)
}
\value{
gibson dataset
}
\description{
The data provide gene expression measurements in peripheral blood leukocyte
samples from three Moroccan groups leading distinct ways of life:
desert nomadic (DESERT), mountain agrarian (VILLAGE), and coastal urban
(AGADIR).
}
\note{
These data are a random subset of 500 genes from the total number of genes
in the original data set. To download the full data set, go to
\url{http://genomine.org/de/}.
}
\examples{
# import
data(gibson)
batch <- gibson$batch
gender <- gibson$gender
location <- gibson$location
gibexpr <- gibson$gibexpr
cov <- data.frame(Batch = batch, Gender = gender,
Location = location)

# create deSet for experiment- static experiment
mNull <- ~Gender + Batch
mFull <- ~Gender + Batch + Location

# create deSet object
de_obj <- build_models(gibexpr, cov = cov, full.model = mFull,
null.model = mNull)

# Perform ODP/lrt statistic to determine significant genes in study
de_odp <- odp(de_obj, bs.its = 10)
de_lrt <- lrt(de_obj, nullDistn = "bootstrap", bs.its = 10)

# summarize significance results
summary(de_odp)
}
\references{
Idaghdour Y, Storey JD, Jadallah S, and Gibson G. (2008) A genome-wide gene
expression signature of lifestyle in peripheral blood of Moroccan Amazighs.
PLoS Genetics, 4: e1000052.
}
\keyword{datasets}

