% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/getMethods.R, R/setMethods.R
\docType{methods}
\name{fullModel}
\alias{fullModel}
\alias{fullModel,deSet-method}
\alias{fullModel<-}
\alias{fullModel<-,deSet-method}
\title{Full model equation}
\usage{
fullModel(object)

fullModel(object) <- value

\S4method{fullModel}{deSet}(object)

\S4method{fullModel}{deSet}(object) <- value
}
\arguments{
\item{object}{\code{S4 object}: \code{\linkS4class{deSet}}}

\item{value}{\code{formula}: The experiment design for the full model.}
}
\value{
the formula for the full model.
}
\description{
These generic functions access and set the full model for
\code{\linkS4class{deSet}} object.
}
\examples{
# import data
library(splines)
data(kidney)
age <- kidney$age
sex <- kidney$sex
kidexpr <- kidney$kidexpr
cov <- data.frame(sex = sex, age = age)

# create models
null_model <- ~sex
full_model <- ~sex + ns(age, df = 4)

# create deSet object from data
de_obj <- build_models(data = kidexpr, cov = cov, null.model = null_model,
full.model = full_model)

# extract out the full model equation
mod_full <- fullModel(de_obj)

# change the full model in the experiment
fullModel(de_obj) <- ~sex + ns(age, df = 2)


}
\author{
John Storey, Andrew Bass
}
\seealso{
\code{\linkS4class{deSet}}
}

