% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{deSet-class}
\alias{deSet-class}
\title{The differential expression class (deSet)}
\description{
The \code{deSet} class extends the \code{\link{ExpressionSet}} class.
While the \code{ExpressionSet} class contains information about the
experiment, the \code{deSet} class contains both experimental information and
additional information relevant for differential expression analysis,
explained below in Slots.
}
\section{Slots}{

\describe{
\item{\code{null.model}}{\code{formula}: contains the adjustment variables in the
experiment. The null model is used for comparison when fitting the
full model.}

\item{\code{full.model}}{\code{formula}: contains the adjustment variables and the
biological variables of interest.}

\item{\code{null.matrix}}{\code{matrix}: the null model as a matrix.}

\item{\code{full.matrix}}{\code{matrix}: the full model as a matrix.}

\item{\code{individual}}{\code{factor}: contains information on which sample
is from which individual in the experiment.}

\item{\code{qvalueObj}}{\code{S3 object}: containing \code{qvalue} object.
See \code{\link{qvalue}} for additional details.}
}}
\note{
See \code{\link{ExpressionSet}} for additional slot information.
}
\section{Methods}{

 \describe{
 \item{\code{as(ExpressionSet, "deSet")}}{Coerce objects of
 \code{ExpressionSet} to \code{deSet}.}
 \item{\code{lrt(deSet, ...)}}{Performs a generalized likelihood ratio test
 using the full and null models.}
 \item{\code{odp(deSet, ...)}}{Performs the optimal discovery procedure,
 which is a new approach for optimally performing many hypothesis tests in
 a high-dimensional study.}
 \item{\code{kl_clust(deSet, ...)}}{An implementation of mODP that assigns
 genes to modules based off of the Kullback-Leibler distance.}
 \item{\code{fit_models(deSet, ...)}}{Fits a linear model to each gene by
 method of least squares.}
 \item{\code{apply_qvalue(deSet, ...)}}{Applies \code{\link{qvalue}}
 function.}
 \item{\code{apply_sva(deSet, ...)}}{Applies surrogate variable analysis
 (\code{\link{sva}}).}
 \item{\code{fullMatrix(deSet)}}{Access and set full matrix.}
 \item{\code{nullMatrix(deSet)}}{Access and set null matrix.}
 \item{\code{fullModel(deSet)}}{Access and set full model.}
 \item{\code{nullModel(deSet)}}{Access and set null model.}
 \item{\code{individual(deSet)}}{Access and set individual slot.}
 \item{\code{qvalueObj(deSet)}}{Access \code{qvalue} object.
 See \code{\link{qvalue}}.}
 \item{\code{validObject(deSet)}}{Check validity of \code{deSet} object.}
 }
}
\author{
John Storey, Jeffrey Leek, Andrew Bass
}

