% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/form_models.R
\name{build_study}
\alias{build_study}
\title{Formulates the experimental models}
\usage{
build_study(data, grp = NULL, adj.var = NULL, bio.var = NULL,
  tme = NULL, ind = NULL, sampling = c("static", "timecourse"),
  basis.df = 2, basis.type = c("ncs", "poly"))
}
\arguments{
\item{data}{\code{matrix}: gene expression data (rows are genes, columns are
samples).}

\item{grp}{\code{vector}: group assignement in the study (for K-class 
studies). Optional.}

\item{adj.var}{\code{matrix}: adjustment variables. Optional.}

\item{bio.var}{\code{matrix}: biological variables. Optional.}

\item{tme}{\code{vector}: time variable in a time course study. Optional.}

\item{ind}{\code{factor}: individual factor for repeated observations of the
same individuals. Optional.}

\item{sampling}{\code{string}: type of study. Either "static" or 
"timecourse". Default is "static".}

\item{basis.df}{\code{numeric}: degrees of freedom of the basis for time 
course study. Default is 2.}

\item{basis.type}{\code{string}: either "ncs" (natural cubic spline) or "ps"
(polynomial spline) basis for time course study. Default is "ncs".}
}
\value{
\code{\linkS4class{deSet}} object
}
\description{
\code{build_study} generates the full and null models for users unfamiliar
with building models in R. There are two types of experimental designs:
static and time-course. For more details, refer to the vignette.
}
\examples{
# create ExpressionSet object from kidney dataset
library(splines)
data(kidney)
age <- kidney$age
sex <- kidney$sex
kidexpr <- kidney$kidexpr

# create deSet object from data
de_obj <- build_study(data = kidexpr, adj.var = sex, tme = age,
sampling = "timecourse", basis.df = 4)
}
\author{
John Storey, Andy Bass
}
\seealso{
\code{\linkS4class{deSet}}, \code{\link{build_models}}
}

