% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reannotate_genes.R
\name{reannotate_genes}
\alias{reannotate_genes}
\title{Gene re-annotation using HGNC symbols}
\usage{
reannotate_genes(cur_genes)
}
\arguments{
\item{cur_genes}{character string containing gene HGNC
symbols to be consider for re-annotation.}
}
\value{
A data.frame with the old gene HGNC symbol and
the new corresponding gene HGNC symbol.
}
\description{
Performs gene re-annotation using curated data
from the HGNC.
}
\details{
Source code adapted from quanTIseq helper function
mapGenes from quantiseqr package.
}
\examples{
\donttest{
# using a SummarizedExperiment object
library(SummarizedExperiment)
# Using example exemplary dataset (Mariathasan et al., Nature, 2018)
# from easierData. Original processed data is available from
# IMvigor210CoreBiologies package.
library("easierData")

dataset_mariathasan <- easierData::get_Mariathasan2018_PDL1_treatment()
RNA_tpm <- assays(dataset_mariathasan)[["tpm"]]

# Select a subset of patients to reduce vignette building time.
pat_subset <- c(
  "SAM76a431ba6ce1", "SAMd3bd67996035", "SAMd3601288319e",
  "SAMba1a34b5a060", "SAM18a4dabbc557"
)
RNA_tpm <- RNA_tpm[, colnames(RNA_tpm) \%in\% pat_subset]

# Select some genes to check possible updated gene names
genes_to_check <- rownames(RNA_tpm)[400:450]
genes_info <- reannotate_genes(cur_genes = genes_to_check)
}
}
