% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_IFNy.R
\name{compute_IFNy}
\alias{compute_IFNy}
\title{Compute IFNy signature (IFNy) score}
\usage{
compute_IFNy(matches, RNA_tpm)
}
\arguments{
\item{matches}{numeric vector indicating the index of
signature genes in \code{RNA_tpm}.}

\item{RNA_tpm}{data.frame containing TPM values with HGNC
symbols in rows and samples in columns.}
}
\value{
A numeric matrix with samples in rows and IFNy
score in a column.
}
\description{
Calculates IFNy signature score as the average expression
of its signature genes, as defined in Ayers et al., J.
Clin. Invest, 2017.
}
\references{
Ayers, M., Lunceford, J., Nebozhyn, M., Murphy,
E., Loboda, A., Kaufman, D.R., Albright, A., Cheng, J.D.,
Kang, S.P., Shankaran, V., et al. (2017). IFN-y-related mRN
A profile predicts clinical response to PD-1 blockade.
J. Clin. Invest. 127, 2930–2940.
https://doi.org/10.1172/JCI91190.
}
