\name{drugTargetBioactivity}
\alias{drugTargetBioactivity}
\title{
drugTargetBioactivity
}
\description{
Function to query bioactivity data by target or compound ids
}
\usage{
drugTargetBioactivity( queryBy=list(molType=NULL, idType=NULL, ids=NULL), cmpid_file=file.path(config$resultsPath,"cmp_ids.rds"),config=genConfig()) 
}
\arguments{
  \item{queryBy}{
	  A list defining the query, as described in  \code{\link{queryBy}}.
}
  \item{cmpid_file}{
	  Path to a compound ID mapping file, generated by \code{\link{cmpIdMapping}}.
}
	\item{config}{ General configuration. See \code{\link{genConfig}}.  }
}
\value{
	Returns results as a data frame.
}
\author{
	Thomas Girke
}


\seealso{
 \code{\link{queryBy}}
 \code{\link{cmpIdMapping}}
}
\examples{
		 config = genConfig(chemblDbPath= 
										system.file("extdata", "chembl_sample.db", package="drugTargetInteractions"),
								  resultsPath = 
										system.file("extdata", "results", package="drugTargetInteractions"))

		 queryBy <- list(molType="protein", idType="uniprot", ids=c("P05979", "P35354", "P33033", "Q8VCT3", "P29475", "P51511"))
		 qresult <- drugTargetBioactivity( queryBy, config=config)

		 queryBy <- list(molType="cmp", idType="molregno", ids=c("101036", "101137", "1384464")) 
		 qresult <- drugTargetBioactivity( queryBy, config=config)

		 queryBy <- list(molType="cmp", idType="DrugBank_ID", ids=c("DB00945", "DB00316", "DB01050")) 
		 qresult <- drugTargetBioactivity(queryBy, config=config)

		 queryBy <- list(molType="cmp", idType="PubChem_ID", ids=c("2244", "3672", "1983")) 
		 qresult <- drugTargetBioactivity(queryBy, config=config)


}
