% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_anchors_list}
\alias{get_anchors_list}
\title{Get a list of anchor pairs for each species}
\usage{
get_anchors_list(
  blast_list = NULL,
  annotation = NULL,
  evalue = 1e-10,
  anchors = 5,
  max_gaps = 25,
  collinearity_dir = NULL
)
}
\arguments{
\item{blast_list}{A list of data frames containing BLAST tabular output
for intraspecies comparisons.
Each list element corresponds to the BLAST output for a given species,
and names of list elements must match the names of list elements in
\code{annotation}. BLASTp, DIAMOND or simular programs must be run on processed
sequence data as returned by \code{process_input()}.}

\item{annotation}{A processed GRangesList or CompressedGRangesList object as
returned by \code{syntenet::process_input()}.}

\item{evalue}{Numeric scalar indicating the E-value threshold.
Default: 1e-10.}

\item{anchors}{Numeric indicating the minimum required number of genes
to call a syntenic block, as in \code{syntenet::infer_syntenet}.
Default: 5.}

\item{max_gaps}{Numeric indicating the number of upstream and downstream
genes to search for anchors, as in \code{syntenet::infer_syntenet}.
Default: 25.}

\item{collinearity_dir}{Character indicating the path to the directory
where .collinearity files will be stored. If NULL, files will
be stored in a subdirectory of \code{tempdir()}. Default: NULL.}
}
\value{
A list of data frames representing intraspecies anchor pairs.
}
\description{
Get a list of anchor pairs for each species
}
\examples{
data(diamond_intra)
data(yeast_annot)
data(yeast_seq)
blast_list <- diamond_intra

# Get processed annotation for S. cerevisiae
annotation <- syntenet::process_input(yeast_seq, yeast_annot)$annotation

# Get list of intraspecies anchor pairs
anchorpairs <- get_anchors_list(blast_list, annotation)
}
