% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_fxns.R
\name{summarize_linkages}
\alias{summarize_linkages}
\title{Summarize linkages from multiple domino objects}
\usage{
summarize_linkages(domino_results, subject_meta, subject_names = NULL)
}
\arguments{
\item{domino_results}{list of domino result with one domino object per subject. Names from the list must match subject_names}

\item{subject_meta}{data frame that includes the subject features by which the objects could be grouped. The first column should must be subject names}

\item{subject_names}{vector of subject names in domino_results. If NULL, defaults to first column of subject_meta.}
}
\value{
A linkage summary class object consisting of nested lists of the active transcription factors, active receptors, and incoming ligands for each cluster across multiple domino results
}
\description{
Creates a \code{\link[=linkage_summary]{linkage_summary()}} object storing the linkages learned in different domino objects as nested lists to facilitate comparisons of networks learned by domino across subject covariates.
}
\examples{
example(build_domino, echo = FALSE)

#create alternative clustering by shuffling cluster assignments
clusters_tiny_alt <- setNames(
  PBMC$clusters_tiny[c(121:240, 1:120, 241:360)], 
  names(PBMC$clusters_tiny)
)
clusters_tiny_alt <- as.factor(clusters_tiny_alt)

#build an alternative domino object
pbmc_dom_tiny_alt <- create_domino(
  rl_map = rl_map_tiny,
  features = SCENIC$auc_tiny,
  counts = PBMC$RNA_count_tiny,
  z_scores = PBMC$RNA_zscore_tiny,
  clusters = clusters_tiny_alt,
  tf_targets = regulon_list_tiny,
  use_clusters = TRUE,
  use_complexes = TRUE,
  remove_rec_dropout = FALSE
)

pbmc_dom_built_tiny_alt <- build_domino(
  dom = pbmc_dom_tiny_alt,
  min_tf_pval = .05,
  max_tf_per_clust = Inf,
  max_rec_per_tf = Inf,
  rec_tf_cor_threshold = .1,
  min_rec_percentage = 0.01
)

#create a list of domino objects
dom_ls <- list(
 dom1 = pbmc_dom_built_tiny,
 dom2 = pbmc_dom_built_tiny_alt
)

#compare the linkages across the two domino objects
meta_df <- data.frame("ID" = c("dom1", "dom2"), "group" = c("A", "B"))
summarize_linkages(
 domino_results = dom_ls, subject_meta = meta_df,
 subject_names = meta_df$ID
)
}
