% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fxns.R
\name{plot_differential_linkages}
\alias{plot_differential_linkages}
\title{Plot differential linkages among domino results ranked by a comparative statistic}
\usage{
plot_differential_linkages(
  differential_linkages,
  test_statistic,
  stat_range = c(0, 1),
  stat_ranking = c("ascending", "descending"),
  group_palette = NULL
)
}
\arguments{
\item{differential_linkages}{a data frame output from the \code{\link[=test_differential_linkages]{test_differential_linkages()}} function}

\item{test_statistic}{column name of differential_linkages where the test statistic used for ranking linkages is stored (ex. 'p.value')}

\item{stat_range}{a two value vector of the minimum and maximum values of test_statistic for plotting linkage features}

\item{stat_ranking}{'ascending' (lowest value of test statisic is colored red and plotted at the top) or 'descending' (highest value of test statistic is colored red and plotted at the top).}

\item{group_palette}{a named vector of colors to use for each group being compared}
}
\value{
A heatmap-class object of features ranked by test_statistic annotated with the proportion of subjects that showed active linkage of the features.
}
\description{
Plot differential linkages among domino results ranked by a comparative statistic
}
\examples{
example(build_domino, echo = FALSE)
example(test_differential_linkages, echo = FALSE)
plot_differential_linkages(
 differential_linkages = tiny_differential_linkage_c1,
 test_statistic = "p.value",
 stat_ranking = "ascending"
)

}
