% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dom_signaling}
\alias{dom_signaling}
\title{Access signaling}
\usage{
dom_signaling(dom, cluster = NULL)
}
\arguments{
\item{dom}{a domino object that has been created with \code{\link[=create_domino]{create_domino()}}}

\item{cluster}{either NULL to indicate global signaling or a specific cluster for which a signaling matrix is desired}
}
\value{
A data frame containing the signaling score through each ligand (row) by each cluster (column) OR
a data frame containing the global summed signaling scores between receptors (rows) and ligands (columns) of each cluster
}
\description{
A function to pull signaling matrices from a domino object
}
\examples{
example(build_domino, echo = FALSE)
monocyte_signaling <- dom_signaling(pbmc_dom_built_tiny, cluster = "CD14_monocyte")

}
