% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{computeUnivariateTernaryMatrix}
\alias{computeUnivariateTernaryMatrix}
\title{Compute the ternary matrix with digitized divergence coding}
\usage{
computeUnivariateTernaryMatrix(seMat, Baseline)
}
\arguments{
\item{seMat}{SummariziedExperiment with an assay in [0, 1], with each column corresponding to a sample and each 
row corresponding to a feature; usually in quantile form.}

\item{Baseline}{A list with a data frame element "Ranges" containing the baseline range of each features; 
this corresponds to the output of findUnivariateGammaWithSupport() or computeUnivariateSupport()}
}
\value{
A matrix containing the ternary form data.
}
\description{
Function for obtaining the ternary form for a matrix of data given a baseline range
}
\examples{
baseMat = breastTCGA_Mat[, breastTCGA_Group == "NORMAL"]
seMat.base = SummarizedExperiment(assays=list(data=baseMat))
assays(seMat.base)$quantile = computeQuantileMatrix(seMat.base)
baseline = computeUnivariateSupport(seMat=seMat.base)
dataMat = breastTCGA_Mat[, breastTCGA_Group != "NORMAL"]
seMat = SummarizedExperiment(assays=list(data=dataMat))
assays(seMat)$quantile = computeQuantileMatrix(seMat)
assays(seMat)$div = computeUnivariateTernaryMatrix(seMat=seMat, Baseline=baseline)

}
\keyword{digitization}
\keyword{ternary}
