% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{computeQuantileMatrix}
\alias{computeQuantileMatrix}
\title{Compute quantile transformations}
\usage{
computeQuantileMatrix(seMat)
}
\arguments{
\item{seMat}{A data matrix in SummarizedExperiment form, with each column corresponding to a sample and each row 
corresponding to a feature.}
}
\value{
A matrix of the same dimensions with the quantile data.
}
\description{
Function for computing the quantile transformation for one or more samples
supplied as columns of a matrix.
}
\examples{
baseMat = breastTCGA_Mat[, breastTCGA_Group == "NORMAL"]
seMat.base = SummarizedExperiment(assays=list(data=baseMat))
assays(seMat.base)$quantile = computeQuantileMatrix(seMat.base)

}
