% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bulk-get-and-set.R
\name{setBulk}
\alias{setBulk}
\alias{setBulk,SingleCellExperiment-method}
\title{Set whether a SingleCellExperiment object should be treated as bulk versus single-cell by dittoSeq}
\usage{
setBulk(object, set = TRUE)

\S4method{setBulk}{SingleCellExperiment}(object, set = TRUE)
}
\arguments{
\item{object}{A target SingleCellExperiment object}

\item{set}{Logical, whether the object should be considered as bulk (TRUE) or not (FALSE)}
}
\value{
A \code{\linkS4class{SingleCellExperiment}} object with "bulk" internal metadata set to \code{set}
}
\description{
Set whether a SingleCellExperiment object should be treated as bulk versus single-cell by dittoSeq
}
\examples{
example(importDittoBulk, echo = FALSE)
myRNA

isBulk(myRNA)

scRNA <- setBulk(myRNA, FALSE)
isBulk(scRNA)

# Now, if we make a heatmap with this data, we will see that single-cell
# defaults (ordering by the first 'annot.by' & cell names not shown) are used.
dittoHeatmap(scRNA, getGenes(scRNA)[1:30],
    annot.by = c("clustering", "groups"),
    main = "isBulk(object) == FALSE")

}
