% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeResults.R
\name{mergeResults}
\alias{mergeResults}
\title{Merge results from different chromosomes}
\usage{
mergeResults(
  chrs = c(seq_len(22), "X", "Y"),
  prefix = ".",
  significantCut = c(0.05, 0.1),
  genomicState,
  minoverlap = 20,
  mergePrep = FALSE,
  ...
)
}
\arguments{
\item{chrs}{The chromosomes of the files to be merged.}

\item{prefix}{The main data directory path, which can be useful if
\link{analyzeChr} is used for several parameters and the results are saved
in different directories.}

\item{significantCut}{A vector of length two specifiying the cutoffs used to
determine significance. The first element is used to determine significance
for the P-values and FWER adjusted P-values, while the second element is
used for the Q-values (FDR adjusted P-values) similar to
\link{calculatePvalues}.}

\item{genomicState}{A GRanges object created with \link{makeGenomicState}.
It can be either the \code{genomicState$fullGenome} or
\code{genomicState$codingGenome} component.}

\item{minoverlap}{Determines the mininum overlap needed when annotating
regions with \link{annotateRegions}.}

\item{mergePrep}{If \code{TRUE} the output from \link{preprocessCoverage} is
merged.}

\item{...}{Arguments passed to other methods and/or advanced arguments.
Advanced arguments:
\describe{
\item{verbose }{ If \code{TRUE} basic status updates will be printed along
the way.}
\item{optionsStats }{ The options used in \link{analyzeChr}. By default
\code{NULL} and will be inferred from the output files.}
\item{cutoffFstatUsed }{ The actual F-statistic cutoff used. This can be
obtained from the logs or from the output of \link{analyzeChr}. If
\code{NULL} then this function will attempt to re-calculate it.}
}
Passed to \link{annotateRegions} and \link{extendedMapSeqlevels}.}
}
\value{
Seven Rdata files.
\describe{
\item{fullFstats.Rdata }{ Full F-statistics from all chromosomes in a list
of Rle objects.}
\item{fullTime.Rdata }{ Timing information from all chromosomes.}
\item{fullNullSummary.Rdata}{ A DataFrame with the null region information:
statistic, width, chromosome and permutation identifier. It's ordered by the
statistics}
\item{fullRegions.Rdata}{ GRanges object with regions found and with full
annotation from \link[bumphunter:matchGenes]{matchGenes}. Note that the column
\code{strand} from \link[bumphunter:matchGenes]{matchGenes} is renamed to
\code{annoStrand} to comply with GRanges specifications. }
\item{fullCoveragePrep.Rdata}{ A list with the pre-processed coverage data
from all chromosomes.}
\item{fullAnnotatedRegions.Rdata}{ A list as constructed in
\link{annotateRegions} with the assigned genomic states.}
\item{optionsMerge.Rdata}{ A list with the options used when merging the
results. Used in \code{derfinderReport::generateReport}.}
}
}
\description{
This function merges the results from running \link{analyzeChr} on several
chromosomes and assigns genomic states using \link{annotateRegions}. It
re-calculates the p-values and q-values using the pooled areas from the null
regions from all chromosomes. Once the results have been merged,
\code{derfinderReport::generateReport} can be used to generate an HTML
report of the results. The \code{derfinderReport} package is available at
https://github.com/lcolladotor/derfinderReport.
}
\details{
If you want to calculate the FWER adjusted P-values, supply
\code{optionsStats} which is produced by \link{analyzeChr}.
}
\examples{
## The output will be saved in the 'generateReport-example' directory
dir.create("generateReport-example", showWarnings = FALSE, recursive = TRUE)

## For convenience, the derfinder output has been pre-computed
file.copy(system.file(file.path("extdata", "chr21"),
    package = "derfinder",
    mustWork = TRUE
), "generateReport-example", recursive = TRUE)

## Merge the results from the different chromosomes. In this case, there's
## only one: chr21
mergeResults(
    chrs = "21", prefix = "generateReport-example",
    genomicState = genomicState$fullGenome
)
\dontrun{
## You can then explore the wallclock time spent on each step
load(file.path("generateReport-example", "fullRegions.Rdata"))

## Process the time info
time <- lapply(fullTime, function(x) data.frame(diff(x)))
time <- do.call(rbind, time)
colnames(time) <- "sec"
time$sec <- as.integer(round(time$sec))
time$min <- time$sec / 60
time$chr <- paste0("chr", gsub("\\\\..*", "", rownames(time)))
time$step <- gsub(".*\\\\.", "", rownames(time))
rownames(time) <- seq_len(nrow(time))

## Make plot
library("ggplot2")
ggplot(time, aes(x = step, y = min, colour = chr)) +
    geom_point() +
    labs(title = "Wallclock time by step") +
    scale_colour_discrete(limits = chrs) +
    scale_x_discrete(limits = names(fullTime[[1]])[-1]) +
    ylab("Time (min)") +
    xlab("Step")
}

}
\seealso{
\link{analyzeChr}, \link{calculatePvalues}, \link{annotateRegions}
}
\author{
Leonardo Collado-Torres
}
