% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_snps.R
\name{add_snps}
\alias{add_snps}
\title{Add SNPs to SingleCellExperiment object}
\usage{
add_snps(sce, mat, thresh = 0.8)
}
\arguments{
\item{sce}{object of class SingleCellExperiment}

\item{mat}{object of class matrix, output from VarTrix in 'consensus' mode
(default)}

\item{thresh}{threshold presence of SNP, defaults to 0.8}
}
\value{
Updated SingleCellExperiment object with snps in altExp slot
}
\description{
Add SNPs to SingleCellExperiment object
}
\examples{
data(multiplexed_scrnaseq_sce, vartrix_consensus_snps)
multiplexed_scrnaseq_sce <- add_snps(sce = multiplexed_scrnaseq_sce, 
mat = vartrix_consensus_snps, 
thresh = 0.8)

}
