% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shearwater-functions.R
\name{bf2Vcf}
\alias{bf2Vcf}
\title{Function to create a \code{\link{VCF}} object with variant calls from an array of Bayes factors.}
\usage{
bf2Vcf(
  BF,
  counts,
  regions,
  samples = 1:nrow(counts),
  err = NULL,
  mu = NULL,
  cutoff = 0.05,
  prior = 0.5,
  mvcf = TRUE
)
}
\arguments{
\item{BF}{array of Bayes factors from \code{\link{bbb}}.}

\item{counts}{array of counts from \code{\link{loadAllData}}.}

\item{regions}{\code{\link{GRanges}} with the regions corresponding to counts and BF.}

\item{samples}{vector of samples names.}

\item{err}{Optional matrix of error rates, otherwise recomputed from counts.}

\item{mu}{Optional matrix of relative frequencies, otherwise recomputed from counts.}

\item{cutoff}{Cutoff for the posterior artifact probability below which a variant is considered to be true (default = 0.05)}

\item{prior}{matrix of prior probabilities for finding a true call, typically from \code{\link{makePrior}}. Alternatively a single fixed number.}

\item{mvcf}{boolean flag, if TRUE compute a large VCF with as many genotype columns as samples. Default TRUE. Otherwise use duplicate rows and only one genotype column. The sample is then provided by the info:PD field. Can be inefficient for large sample sizes.}
}
\value{
A \code{\link{VCF}} object
}
\description{
This function thresholds the Bayes factors computed by the shearwater algorithm and creates a \code{\link{VCF}} object as output.
}
\note{
Experimental code, subject to changes
}
\author{
mg14
}
