% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDecomposedContribution.R
\name{plotDecomposedContribution}
\alias{plotDecomposedContribution}
\title{Plot the decomposition (contributions/exposures) of a tumor genome.}
\usage{
plotDecomposedContribution(decomposition, signatures=NULL,
removeNA=TRUE)
}
\arguments{
\item{decomposition}{(Mandatory) A decomposition vector (exposure vector)
obtained for a single tumor genome.}

\item{signatures}{(Optional) A list object containing the signatures used
to compute the decomposition. If specified, the signature labels used in
the plot will be taken from the element names of the list; otherwise
signature names will be taken from the exposure object (decomposition) or
named from sign_1 to sign_N.}

\item{removeNA}{(Optional) If \code{TRUE} (default), signatures with
an NA as exposure will not be included on the x-axis of the the plot.
Exposures can be NA if they have been determined with a greedy search.}
}
\value{
Returns (or draws) a plot of the decomposed tumor genome (i.e.,
contributions of the single signatures).
}
\description{
`plotDecomposedContribution()` plots the decomposition of a tumor genome,
i.e., the contributions/exposures obtained from \code{decomposeTumorGenomes}
for a set of signatures.
}
\examples{

### get Alexandrov signatures from COSMIC
signatures <- readAlexandrovSignatures()

### load preprocessed breast cancer genomes (object 'genomes') from
### Nik-Zainal et al (PMID: 22608084) 
gfile <- system.file("extdata",
         "Nik-Zainal_PMID_22608084-genomes-Alexandrov_3bases.Rdata", 
         package="decompTumor2Sig")
load(gfile)

### compute exposures
exposures <- decomposeTumorGenomes(genomes, signatures, verbose=FALSE)

### plot signature composition of the first genome
plotDecomposedContribution(exposures[[1]], signatures=NULL)

}
\references{
\url{http://rmpiro.net/decompTumor2Sig/}\cr
Krueger, Piro (2019) decompTumor2Sig: Identification of mutational
signatures active in individual tumors. BMC Bioinformatics
20(Suppl 4):152.\cr
}
\seealso{
\code{\link{decompTumor2Sig}}\cr
\code{\link{decomposeTumorGenomes}}
}
\author{
Rosario M. Piro\cr Politecnico di Milano\cr Maintainer: Rosario
M. Piro\cr E-Mail: <rmpiro@gmail.com> or <rosariomichael.piro@polimi.it>
}
