% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeExplainedVariance.R
\name{computeExplainedVariance}
\alias{computeExplainedVariance}
\title{Compute the explained variance.}
\usage{
computeExplainedVariance(exposures, signatures, genomes)
}
\arguments{
\item{exposures}{(Mandatory) A single vector or list of vectors containing
the estimated signature contributions/exposures as provided by the function
\code{decomposeTumorGenomes}. A list of vectors is used if the explained
variance shall be computed for multiple genomes. The number of exposure
vectors must correspond to the number of \code{genomes}. The number
of elements of each exposure vector must correspond to the number of
\code{signatures}.}

\item{signatures}{(Mandatory) The list of signatures (vectors, data frames
or matrices) for which the exposures were obtained. Each of the list
objects represents one mutational signature. Vectors are used for
Alexandrov signatures, data frames or matrices for Shiraishi signatures.}

\item{genomes}{(Mandatory) Can be either a vector, a data frame or a matrix
(for an individual tumor genome), or a list of one of these object types
(for multiple tumors). Each tumor genome must be of the same form as the
\code{signatures}.}
}
\value{
A numeric vector of explained variances, one for each genome.
}
\description{
`computeExplainedVariance()` computes for one or more tumors the variance
which is explained by the estimated contributions (exposures) of a set of
signatures when compared to the observed genomes.
}
\examples{

### get Alexandrov signatures from COSMIC
signatures <- readAlexandrovSignatures()

### load preprocessed breast cancer genomes (object 'genomes') from
### Nik-Zainal et al (PMID: 22608084) 
gfile <- system.file("extdata",
         "Nik-Zainal_PMID_22608084-genomes-Alexandrov_3bases.Rdata", 
         package="decompTumor2Sig")
load(gfile)

### compute exposures
exposures <- decomposeTumorGenomes(genomes, signatures, verbose=FALSE)

### compute explained variance for the tumor genomes
computeExplainedVariance(exposures, signatures, genomes)

}
\references{
\url{http://rmpiro.net/decompTumor2Sig/}\cr
Krueger, Piro (2019) decompTumor2Sig: Identification of mutational
signatures active in individual tumors. BMC Bioinformatics 
20(Suppl 4):152.\cr
}
\seealso{
\code{\link{decompTumor2Sig}}\cr
\code{\link{decomposeTumorGenomes}}\cr
\code{\link{plotExplainedVariance}}
}
\author{
Rosario M. Piro\cr Politecnico di Milano\cr Maintainer: Rosario
M. Piro\cr E-Mail: <rmpiro@gmail.com> or <rosariomichael.piro@polimi.it>
}
