# Generated by roxytest: do not edit by hand!

# File R/misc.R: @tests

test_that("Function rand_id() @ L15", {
  set.seed(123)
  expect_equal(rand_id(), "step__Filo")
})


test_that("Function get_comparisons() @ L49", {
  data("metaHIV_phy")
  phy <- metaHIV_phy
  var <- "RiskGroup2"
  
  is_list <- get_comparisons(var, phy)
  is_tibb <- get_comparisons(var, phy, as_list = FALSE)
  filtered <- get_comparisons(var, phy, n_cut = 30)
  
  expect_equal(class(is_list), "list")
  expect_s3_class(is_tibb, "tbl_df")
  expect_length(is_list, 3)
  expect_equal(nrow(is_tibb), 3)
  expect_length(filtered, 1)
})


test_that("Function to_tibble() @ L100", {
  data("metaHIV_phy")
  phy <- metaHIV_phy
  df <- phyloseq::otu_table(phy)
  
  test_1 <- to_tibble(df)
  test_2 <- to_tibble(df, id_name = "random_id")
  
  expect_length(test_1, 157)
  expect_s3_class(test_1, "tbl_df")
  expect_s3_class(test_2, "tbl_df")
  expect_equal(names(test_1)[1], "otu_id")
  expect_equal(names(test_2)[1], "random_id")
})


test_that("Function step_to_expr() @ L119", {
  data(test_prep_rec)
  exprs <- test_prep_rec@steps |> purrr::map_chr(step_to_expr)
  expect_length(exprs, 5)
  expect_true(all(stringr::str_detect(exprs, "run_")))
})


test_that("Function find_intersections() @ L191", {
  data(test_prep_rec)
  res_1 <- find_intersections(
    test_prep_rec, steps = steps_ids(test_prep_rec, type = "da")
  )
  res_2 <- find_intersections(
    test_prep_rec, steps = steps_ids(test_prep_rec, type = "da")[-1]
  )
  res_3 <- find_intersections(
    test_prep_rec, steps = steps_ids(test_prep_rec, type = "da")[-2]
  )
  
  expect_equal(nrow(res_1), 88)
  expect_equal(nrow(res_2), 36)
  expect_equal(nrow(res_3), 86)
  expect_s3_class(res_1, "tbl_df")
})


test_that("Function steps_ids() @ L253", {
  data(test_prep_rec)
  print(test_prep_rec) |> expect_snapshot()
  rec <- test_prep_rec
  expect_equal(
    steps_ids(rec), 
    c("subset_taxa__Boyoz",
      "filter_taxa__Charlotte", 
      "maaslin__ChaSan", 
      "metagenomeseq__Zlebia", 
      "deseq__Linzer_torte"    
     )
  )
  expect_equal(
    steps_ids(rec, "da"), 
    c("maaslin__ChaSan", "metagenomeseq__Zlebia", "deseq__Linzer_torte")
  )
  expect_equal(
    steps_ids(rec, "prepro"), 
    c("subset_taxa__Boyoz", "filter_taxa__Charlotte")
  )
  expect_error(steps_ids(rec, "das"))
  expect_type(steps_ids(rec), "character")
})


test_that("Function export_steps() @ L331", {
  data(test_prep_rec)
  file <- tempfile(fileext = ".json") 
  export_steps(test_prep_rec, file)
  readr::read_lines(file) |> 
    expect_snapshot()
})


test_that("Function import_steps() @ L398", {
  data(metaHIV_phy)
  recipe(metaHIV_phy, "RiskGroup2", "Class") |> 
   import_steps(system.file("extdata", "test_bake.json", package = "dar")) |> 
   expect_snapshot()
})

