% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metagenomeseq.R
\name{step_metagenomeseq}
\alias{step_metagenomeseq}
\alias{step_metagenomeseq,Recipe-method}
\alias{step_metagenomeseq,PrepRecipe-method}
\title{MetagenomeSeq analysis}
\usage{
step_metagenomeseq(
  rec,
  zeroMod = NULL,
  useCSSoffset = TRUE,
  useMixedModel = FALSE,
  max_significance = 0.05,
  log2FC = 0,
  rarefy = FALSE,
  rm_zeros = 0,
  id = rand_id("metagenomeseq")
)

\S4method{step_metagenomeseq}{Recipe}(
  rec,
  zeroMod = NULL,
  useCSSoffset = TRUE,
  useMixedModel = FALSE,
  max_significance = 0.05,
  log2FC = 0,
  rarefy = FALSE,
  rm_zeros = 0,
  id = rand_id("metagenomeseq")
)

\S4method{step_metagenomeseq}{PrepRecipe}(
  rec,
  zeroMod = NULL,
  useCSSoffset = TRUE,
  useMixedModel = FALSE,
  max_significance = 0.05,
  log2FC = 0,
  rarefy = FALSE,
  rm_zeros = 0,
  id = rand_id("metagenomeseq")
)
}
\arguments{
\item{rec}{A Recipe object. The step will be added to the sequence of
operations for this Recipe.}

\item{zeroMod}{The zero model, the model to account for the change in the
number of OTUs observed as a linear effect of the depth of coverage.}

\item{useCSSoffset}{Boolean, whether to include the default scaling
parameters in the model or not.}

\item{useMixedModel}{Estimate the correlation between duplicate features or
replicates using duplicateCorrelation.}

\item{max_significance}{The q-value threshold for significance.}

\item{log2FC}{log2FC cutoff.}

\item{rarefy}{Boolean indicating if OTU counts must be rarefyed. This
rarefaction uses the standard R sample function to resample from the
abundance values in the otu_table component of the first argument, physeq.
Often one of the major goals of this procedure is to achieve parity in
total number of counts between samples, as an alternative to other formal
normalization procedures, which is why a single value for the sample.size
is expected. If 'no_seed', rarefaction is performed without a set seed.}

\item{rm_zeros}{Proportion of samples of the same categorical level with more
than 0 counts.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An object of class \code{Recipe}
}
\description{
metagenomeSeq is designed to determine features (be it Operational Taxanomic
Unit (OTU), species, etc.) that are differentially abundant between two or
more groups of multiple samples. metagenomeSeq is designed to address the
effects of both normalization and under-sampling of microbial communities on
disease association detection and the testing of feature correlations.
}
\examples{
data(metaHIV_phy)

## Init Recipe
rec <-
  recipe(metaHIV_phy, "RiskGroup2", "Phylum") |>
  step_subset_taxa(tax_level = "Kingdom", taxa = c("Bacteria", "Archaea")) |>
  step_filter_taxa(.f = "function(x) sum(x > 0) >= (0.02 * length(x))")

rec

## Define step with default parameters and prep
rec <-
  step_metagenomeseq(rec, rm_zeros = 0.01) |>
  prep(parallel = FALSE)

rec

## Wearing rarefaction only for this step
rec <-
  recipe(metaHIV_phy, "RiskGroup2", "Species") |>
  step_metagenomeseq(rarefy = TRUE)

rec
}
\seealso{
Other Diff taxa steps: 
\code{\link{step_aldex}()},
\code{\link{step_ancom}()},
\code{\link{step_corncob}()},
\code{\link{step_deseq}()},
\code{\link{step_lefse}()},
\code{\link{step_maaslin}()},
\code{\link{step_wilcox}()}
}
\concept{Diff taxa steps}
