% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maaslin2.R
\name{step_maaslin}
\alias{step_maaslin}
\alias{step_maaslin,Recipe-method}
\alias{step_maaslin,PrepRecipe-method}
\title{MaAsLin2 analysis}
\usage{
step_maaslin(
  rec,
  min_abundance = 0,
  min_prevalence = 0.1,
  min_variance = 0,
  normalization = "TSS",
  transform = "LOG",
  analysis_method = "LM",
  max_significance = 0.25,
  random_effects = NULL,
  correction = "BH",
  standardize = TRUE,
  reference = NULL,
  rarefy = FALSE,
  id = rand_id("maaslin")
)

\S4method{step_maaslin}{Recipe}(
  rec,
  min_abundance = 0,
  min_prevalence = 0.1,
  min_variance = 0,
  normalization = "TSS",
  transform = "LOG",
  analysis_method = "LM",
  max_significance = 0.25,
  random_effects = NULL,
  correction = "BH",
  standardize = TRUE,
  reference = NULL,
  rarefy = FALSE,
  id = rand_id("maaslin")
)

\S4method{step_maaslin}{PrepRecipe}(
  rec,
  min_abundance = 0,
  min_prevalence = 0.1,
  min_variance = 0,
  normalization = "TSS",
  transform = "LOG",
  analysis_method = "LM",
  max_significance = 0.25,
  random_effects = NULL,
  correction = "BH",
  standardize = TRUE,
  reference = NULL,
  rarefy = FALSE,
  id = rand_id("maaslin")
)
}
\arguments{
\item{rec}{A Recipe object. The step will be added to the sequence of
operations for this Recipe.}

\item{min_abundance}{The minimum abundance for each feature.}

\item{min_prevalence}{The minimum percent of samples for which a feature is
detected at minimum abundance.}

\item{min_variance}{Keep features with variance greater than.}

\item{normalization}{The normalization method to apply. Default: "TSS".
Choices: "TSS", "CLR", "CSS", "NONE", "TMM".}

\item{transform}{The transform to apply. Default: "LOG". Choices: "LOG",
"LOGIT", "AST", "NONE".}

\item{analysis_method}{The analysis method to apply. Default: "LM". Choices:
"LM", "CPLM", "ZICP", "NEGBIN", "ZINB".}

\item{max_significance}{The q-value threshold for significance.}

\item{random_effects}{The random effects for the model, comma-delimited for
multiple effects.}

\item{correction}{The correction method for computing the q-value.}

\item{standardize}{Apply z-score so continuous metadata are on the same
scale.}

\item{reference}{The factor to use as a reference for a variable with more
than two levels provided as a string of 'variable,reference' semi-colon
delimited for multiple variables.}

\item{rarefy}{Boolean indicating if OTU counts must be rarefyed. This
rarefaction uses the standard R sample function to resample from the
abundance values in the otu_table component of the first argument, physeq.
Often one of the major goals of this procedure is to achieve parity in
total number of counts between samples, as an alternative to other formal
normalization procedures, which is why a single value for the sample.size
is expected. If 'no_seed', rarefaction is performed without a set seed.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An object of class \code{Recipe}
}
\description{
MaAsLin2 finds associations between microbiome meta-omics features and
complex metadata in population-scale epidemiological studies. The software
includes multiple analysis methods (including support for multiple covariates
and repeated measures), filtering, normalization, and transform options to
customize analysis for your specific study.
}
\examples{
data(metaHIV_phy)

## Init Recipe
rec <-
  recipe(metaHIV_phy, "RiskGroup2", "Phylum") |>
  step_subset_taxa(tax_level = "Kingdom", taxa = c("Bacteria", "Archaea")) |>
  step_filter_taxa(.f = "function(x) sum(x > 0) >= (0.4 * length(x))")

rec

## Define step with default parameters and prep
rec <-
  step_maaslin(rec) |>
  prep(parallel = FALSE)

rec

## Wearing rarefaction only for this step
rec <-
  recipe(metaHIV_phy, "RiskGroup2", "Species") |>
  step_maaslin(rarefy = TRUE)

rec
}
\seealso{
Other Diff taxa steps: 
\code{\link{step_aldex}()},
\code{\link{step_ancom}()},
\code{\link{step_corncob}()},
\code{\link{step_deseq}()},
\code{\link{step_lefse}()},
\code{\link{step_metagenomeseq}()},
\code{\link{step_wilcox}()}
}
\concept{Diff taxa steps}
