% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_methods.R
\name{intersection_plt}
\alias{intersection_plt}
\alias{intersection_plt,Recipe-method}
\alias{intersection_plt,PrepRecipe-method}
\title{Plot results using UpSet plot}
\usage{
intersection_plt(
  rec,
  steps = steps_ids(rec, "da"),
  ordered_by = c("freq", "degree"),
  font_size = 2
)

\S4method{intersection_plt}{Recipe}(rec, steps, font_size)

\S4method{intersection_plt}{PrepRecipe}(
  rec,
  steps = steps_ids(rec, "da"),
  ordered_by = c("freq", "degree"),
  font_size = 2
)
}
\arguments{
\item{rec}{A \code{Recipe} object.}

\item{steps}{Character vector with step_ids to take in account.}

\item{ordered_by}{How the intersections in the matrix should be ordered by.
Options include frequency (entered as "freq"), degree, or both in any
order.}

\item{font_size}{Size of the font.}
}
\value{
UpSet plot
}
\description{
Plot results using UpSet plot
}
\examples{
data(test_prep_rec)

## Running the function returns a UpSet plot ordered by frequency.
intersection_plt(test_prep_rec)

## Alternatively, you can order the plot by degree
intersection_plt(test_prep_rec, ordered_by = "degree")

## If you want to exclude a method for the plot, you can remove it with the
## step parameter. In the following example we eliminate from the graph the
## results of maaslin
intersection_plt(test_prep_rec, steps = steps_ids(test_prep_rec, "da")[-1])

## intersection_plt function needs a PrepRecipe. If you pass a a non-prep
## Recipe the output is an error.
data(test_rec)
err <- testthat::expect_error(intersection_plt(test_rec))
err
}
