% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_by_variance.R
\name{step_filter_by_variance}
\alias{step_filter_by_variance}
\alias{step_filter_by_variance,Recipe-method}
\alias{step_filter_by_variance,PrepRecipe-method}
\title{Filter taxa by variance}
\usage{
step_filter_by_variance(
  rec,
  threshold = 0.01,
  id = rand_id("filter_by_variance")
)

\S4method{step_filter_by_variance}{Recipe}(
  rec,
  threshold = 0.01,
  id = rand_id("filter_by_variance")
)

\S4method{step_filter_by_variance}{PrepRecipe}(
  rec,
  threshold = 0.01,
  id = rand_id("filter_by_variance")
)
}
\arguments{
\item{rec}{A Recipe object. The step will be added to the sequence of
operations for this Recipe.}

\item{threshold}{The variance threshold for filtering taxa. The default value
is 0.01.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
A Recipe object that has been filtered based on variance.
}
\description{
This is a convenience function around the filter_taxa function. It is
designed to speed up filtering complex experimental objects with one function
call. In the case of run_filter_by_variance, the filtering will be based on
the variance of each taxon. The taxa retained in the dataset are those where
the variance of their abundance is greater than the provided threshold.
}
\details{
The function calculates the variance of all taxa in the phyloseq
object. It then compares this variance to the variance of each individual
taxon. If a taxon's variance is less than the threshold, that taxon is
removed from the phyloseq object.
}
\note{
This function modifies \code{rec} in place, you might want to make a copy of
\code{rec} before modifying it if you need to preserve the original object.
}
\examples{
data(metaHIV_phy)

## Init Recipe
rec <- recipe(metaHIV_phy, "RiskGroup2", "Phylum")
rec

## Define step_filter_by_variance step with default parameters
rec <- step_filter_by_variance(rec, threshold = 0.01)
rec
}
\seealso{
\code{\link[phyloseq]{filter_taxa}}

Other filter phy steps: 
\code{\link{step_filter_by_abundance}()},
\code{\link{step_filter_by_prevalence}()},
\code{\link{step_filter_by_rarity}()},
\code{\link{step_filter_taxa}()}
}
\concept{filter phy steps}
