% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_methods.R
\name{exclusion_plt}
\alias{exclusion_plt}
\alias{exclusion_plt,Recipe-method}
\alias{exclusion_plt,PrepRecipe-method}
\title{Plot the number of shared DA OTUs between methods.}
\usage{
exclusion_plt(rec, steps = steps_ids(rec, "da"))

\S4method{exclusion_plt}{Recipe}(rec, steps = steps_ids(rec, "da"))

\S4method{exclusion_plt}{PrepRecipe}(rec, steps = steps_ids(rec, "da"))
}
\arguments{
\item{rec}{A \code{Recipe} object.}

\item{steps}{Character vector with step_ids to take in account.}
}
\value{
ggplot2-class object
}
\description{
Plot the number of shared DA OTUs between methods.
}
\examples{
data(test_prep_rec)

## Running the function returns a barplot plot,
exclusion_plt(test_prep_rec)

## If you want to exclude a method for the plot, you can remove it with the
## step parameter. In the following example we eliminate from the graph the
## results of maaslin
exclusion_plt(test_prep_rec, steps = steps_ids(test_prep_rec, "da")[-1])

## intersection_plt function needs a PrepRecipe. If you pass a a non-prep
## Recipe the output is an error.
data(test_rec)
err <- testthat::expect_error(exclusion_plt(test_rec))
err
}
