% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareProteomeByFTP.R
\name{prepareProteomeByFTP}
\alias{prepareProteomeByFTP}
\title{Create an object of \code{\link{Proteome}} Class.}
\usage{
prepareProteomeByFTP(
  source = "UniProt",
  taxonID = NULL,
  species = NULL,
  destDir = tempdir(check = TRUE),
  fastaFile,
  ...
)
}
\arguments{
\item{source}{A character vector of length 1 or NULL. A database source from 
which the proteome sequences are to be downloaded. By default, currently it is
"UniProt". If it is NULL, then \code{fastaFile} has to be specified. The 
priority of \code{source} is higher than \code{fastaFile}.}

\item{taxonID}{An integer(1), specifying Taxonomy ID for a species of interest.
Check the NCBI taxonomy database: \url{https://www.ncbi.nlm.nih.gov/taxonomy} 
or the UniProt database \url{http://www.uniprot.org/taxonomy/}. At least one 
of the two parameters, \code{taxonID} and \code{species}, should be specified. 
If both are specified, \code{taxonID} will be used preferentially.}

\item{species}{A character vector of length 1. The Latin name of a species 
confirming to the Linnaean taxonomy nomenclature system. CAUTION: for species 
with different strains, attention should be paid. You can interactively choose
the right \code{taxonID} from an output list.}

\item{destDir}{A character vector of length 1. A destination directory with 
writing permission for saving downloaded sequences. Default is a temporary 
directory in the system's temporary directory.}

\item{fastaFile}{A character vector of length 1. A fasta file name from which
protein sequences are read in.}

\item{...}{other parameters passing to the function \code{\link{download.file}}.}
}
\value{
An object of Proteome
}
\description{
Create an object of \code{\link{Proteome}} Class by downloading a whole 
proteome data from UniProt for a given organism of an NCBI taxonomy ID or 
species' scientific name, or by using peptide sequences in a fasta file.
}
\examples{
\dontrun{
## Prepare an objecto of Proteome Class for a proteome from the UniProt database
#' proteome <- prepareProteomeByFTP(source = "UniProt", species = "Homo sapiens")
}
## Prepare an objecto of Proteome Class from a fasta file
fasta <- system.file("extdata", "HUMAN.fasta", package="dagLogo")
proteome <- prepareProteomeByFTP(source = NULL, species = "Homo sapiens", 
fastaFile=fasta)
}
\author{
Haibo Liu
}
