% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy.R
\name{makeTaxonomyFasta_GG2}
\alias{makeTaxonomyFasta_GG2}
\title{This function creates the dada2 assignTaxonomy training fasta from the GreenGenes2
release files. If `include.species`=TRUE, the 7th taxonomic level (species) will be output.
Otherwise only the first 6 taxonomic levels (down to genus) will output.}
\usage{
makeTaxonomyFasta_GG2(
  fn,
  txfn,
  fout,
  include.species = FALSE,
  output.binomials = FALSE,
  compress = TRUE
)
}
\description{
## Greengenes2 release 2024_09
path <- "~/tax/GG2/2024_09"
setwd(path)
# download.file("http://ftp.microbio.me/greengenes_release/current/2024.09.backbone.full-length.fna.qza", 
              "2024.09.backbone.full-length.fna.qza")
download.file("http://ftp.microbio.me/greengenes_release/current/2024.09.backbone.tax.qza",
              "2024.09.backbone.tax.qza")
unzip("2024.09.backbone.full-length.fna.qza")
unzip("2024.09.backbone.tax.qza")
fn <- "5b42d9b6-2f24-4f01-b989-9b4dafca7d5e/data/dna-sequences.fasta"
txfn <- "b7c3e691-ea51-4547-94dd-f79f49e41a36/data/taxonomy.tsv"
}
\details{
fn.out <- "~/Desktop/gg2_2024_09_toGenus_trainset.fa.gz"
dada2:::makeTaxonomyFasta_GG2(fn, txfn, fn.out, include.species=FALSE, compress=TRUE)
dada2:::tax.check(fn.out)

fn.out.spc <- "~/Desktop/gg2_2024_09_toSpecies_trainset.fa.gz"
dada2:::makeTaxonomyFasta_GG2(fn, txfn, fn.out.spc, include.species=TRUE, compress=TRUE)
dada2:::tax.check(fn.out.spc)
}
\keyword{internal}
