% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRegions.R
\name{getRegions}
\alias{getRegions}
\title{Constructs potential differentially reactive regions.}
\usage{
getRegions(
  d_within,
  d_spec,
  rdf,
  min_length = 11,
  check_signal_strength = TRUE,
  check_nucs = TRUE,
  check_quality = TRUE,
  quality = 0.5,
  evidence = 0,
  signal_strength = 0.1
)
}
\arguments{
\item{d_within}{Nucleotide-wise d score for within-group variation.}

\item{d_spec}{Nucleotide-wise d score for between-group variation.}

\item{rdf}{Dataframe of reactivities for each sample.}

\item{min_length}{Minimum length of constructed regions.}

\item{check_signal_strength}{Logical, if TRUE, construction of regions must be based on nucleotides that have a minimum absolute value of reactivity.}

\item{check_nucs}{Logical, if TRUE, constructed regions must have a minimum number of nucleotides participating in Wilcoxon signed rank test.}

\item{check_quality}{Logical, if TRUE, check constructed regions for quality.}

\item{quality}{Worst allowed quality for a region to be tested.}

\item{evidence}{Minimum evidence of increase in variation from within-group comparisons to between-group comparisons for a region to be tested.}

\item{signal_strength}{Threshold for minimum signal strength.}
}
\value{
Integer vector of nucleotides that constitute potential differentially reactive regions.
}
\description{
This function takes between- and within-group \emph{d} scores for a
transcript as input and identifies regions where the former is generally larger.
Regions that pass minimum quality and minimum signal criteria are returned.
}
\references{
Choudhary, K., Lai, Y. H., Tran, E. J., & Aviran, S. (2019).
dStruct: identifying differentially reactive regions from RNA
structurome profiling data. \emph{Genome biology}, 20(1), 1-26.
}
\author{
Krishna Choudhary
}
