% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lnTrans.R
\name{lnTrans}
\alias{lnTrans}
\title{log transforms the expression matrix of a flowframe}
\usage{
lnTrans(x, notToTransform = c("SSC.W", "TIME"))
}
\arguments{
\item{x}{flowframe to be transformed}

\item{notToTransform}{columns not to be transformed}
}
\value{
\strong{flowframe} with log transformed expression matrix
}
\description{
log transforms the expression matrix of a flowframe
}
\examples{
flowfile_path <- system.file("extdata", "B4_18_1.fcs", 
                 package = "cyanoFilter",
              mustWork = TRUE)
flowfile <- flowCore::read.FCS(flowfile_path, alter.names = TRUE,
                               transformation = FALSE, emptyValue = FALSE,
                               dataset = 1) 
flowfile_nona <- cyanoFilter::noNA(x = flowfile)
flowfile_noneg <- cyanoFilter::noNeg(x = flowfile_nona)
lnTrans(x = flowfile_noneg, c('SSC.W', 'TIME'))

}
