% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{ggpairsDens}
\alias{ggpairsDens}
\title{produces a scatter plot of the expression matrix of the flowframe. 
If a cluster variable is given,
it assigns different colors to the clusters.}
\usage{
ggpairsDens(flowfile, channels = NULL, group = NULL, notToPlot = NULL, ...)
}
\arguments{
\item{flowfile}{flowframe to be plotted}

\item{channels}{a character vector of length 2 or more. It must contain 
channel names in the flowfile.}

\item{group}{cluster groups. It must be equal to the number of particles 
in the flowfile. If group is null cluster boundaries are not 
drawn.}

\item{notToPlot}{columns not to plot. This is especially useful for for 
plotting all columns in a}

\item{...}{not used at the moment

 @return a ggplot object}
}
\value{
a ggplot object
}
\description{
produces a scatter plot of the expression matrix of the flowframe. 
If a cluster variable is given,
it assigns different colors to the clusters.
}
\examples{

 # example without clustering
flowfile_path <- system.file("extdata", "B4_18_1.fcs", 
                 package = "cyanoFilter",
                 mustWork = TRUE)
flowfile <- flowCore::read.FCS(flowfile_path, alter.names = TRUE,
                               transformation = FALSE, emptyValue = FALSE,
                               dataset = 1) 
flowfile_nona <- cyanoFilter::noNA(x = flowfile)
flowfile_noneg <- cyanoFilter::noNeg(x = flowfile_nona)
flowfile_logtrans <- lnTrans(x = flowfile_noneg, c('SSC.W', 'TIME'))
ggpairsDens(flowfile = flowfile_logtrans,
            channels = c("FSC.HLin", "RED.R.HLin", "RED.B.HLin", 
            "NIR.R.HLin"))
}
