% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customAnnot.R
\name{addCustomAnnot}
\alias{addCustomAnnot}
\alias{customAnnot}
\alias{deleteAnnot}
\alias{listAnnot}
\alias{defaultAnnot}
\title{Add/Delete Custom Annotation}
\usage{
addCustomAnnot(annot_tb, id_col = NULL, annot_name, overwrite = FALSE)

deleteAnnot(annot_name)

listAnnot()

defaultAnnot()
}
\arguments{
\item{annot_tb}{data.frame representing the custom annotation table,
Note, it should contains a 'chembl_id' column representing the compound
ChEMBL ids}

\item{id_col}{column name in \code{annot_tb} that is used as ID column, 
this column must contain unique identifiers. If not defined, an automatically
generated ID column will be appended.}

\item{annot_name}{character(1), user defined name of the annotation table}

\item{overwrite}{a logical specifying whether to overwrite an existing table 
or not. Its default is FALSE.}
}
\value{
character vector of names of the annotation tables in the SQLite DB

character(1), path to the annotation SQLite database
}
\description{
Functions could be used to add/delete user's custom compound annotations
from the annotation SQLite database.
The added custom compound annotation table should contains a column named as
\code{chembl_id} that represents the ChEMBL ids of the added compounds.

The \code{listAnnot} function lists the available annotation
resources in the SQLite annotation database.

The \code{defaultAnnot} function sets the annotation SQLite
database to the default one by deleting the existing one and re-downloading
from AnnotationHub.
}
\examples{
chembl_id <- c("CHEMBL1000309", "CHEMBL100014", "CHEMBL10",
               "CHEMBL100", "CHEMBL1000", NA)
annot_tb <- data.frame(compound_name=paste0("name", 1:6),
        chembl_id=chembl_id,
        feature1=paste0("f", 1:6),
        feature2=rnorm(6))
addCustomAnnot(annot_tb, annot_name="mycustom3")
deleteAnnot("mycustom3")
annot_names <- listAnnot()
# defaultAnnot()
}
