% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_rho_and_var.R
\name{run_csd}
\alias{run_csd}
\title{Run CSD analysis}
\usage{
run_csd(
  x_1,
  x_2,
  n_it = 20L,
  nThreads = 1L,
  verbose = TRUE,
  iterations_gap = 1L
)
}
\arguments{
\item{x_1}{Numeric matrix, the gene expression matrix for
the first condition.
Genes are in columns, samples are in rows.
The columns must be named with the name of the genes.
Missing values are not allowed.}

\item{x_2}{Numeric matrix, the gene expression matrix for
the second condition.}

\item{n_it}{Integer, number of bootstrap iterations}

\item{nThreads}{Integer, number of threads to use for computations}

\item{verbose}{Logical, should progress be printed?}

\item{iterations_gap}{If output is verbose - Number of iterations between
each status message
(Default=1 - Displayed only if \code{verbose=TRUE})}
}
\value{
A \code{data.frame} with
the additional class attribute \code{csd_res} with the
results of the CSD analysis.
This frame has a row for each pair of genes and has the
following columns: \describe{
\item{\code{Gene1}}{Character, the name of the first gene}
\item{\code{Gene2}}{Character, the name of the second gene}
\item{\code{rho1}}{Mean correlation of the two genes in the first condition}
\item{\code{rho2}}{Mean correlation of the two genes in the second condition}
\item{\code{var1}}{The estimated variance of \code{rho1}
determined by bootstrapping}
\item{\code{var2}}{The estimated variance of \code{rho2}
determined by bootstrapping}
\item{\code{cVal}}{Numeric, the conserved score.
A high value indicates that the co-expression of the two genes
have the same sign in both conditions}
\item{\code{sVal}}{Numeric, the specific score.
A high value indicates that the co-expression of the two genes
have a high degree of co-expression in
one condition, but not the other.}
\item{\code{dVal}}{Numeric, the differentiated score.
A high value indicates that the co-expression of the two genes have
a high degree of co-expression in
both condition, but the sign of co-expression is different.}
}
}
\description{
This function implements the CSD algorithm based on the
one presented by Voigt et al. 2017. All pairs of genes are
first compared within each condition by the Spearman correlation
and the correlation and its variance are
estimated by bootstrapping.
Finally, the results for the two conditions are
compared and C-, S- and D-values are computed
and returned.
}
\details{
The gene names in \code{x_1} and \code{x_2}
do not need to be in the same order,
but must be in the same namespace.
Only genes present in both datasets will be considered for the analysis.
The parallelism gained by \code{nThreads} applies to the computations
within a single iteration. The iterations are run is serial in order
to reduce the memory footprint.
}
\examples{
data("sick_expression")
data("normal_expression")
cor_res <- run_csd(
    x_1 = sick_expression, x_2 = normal_expression,
    n_it = 100, nThreads = 2L
)
c_max <- max(cor_res$cVal)
}
\references{
Voigt A, Nowick K and Almaas E
'A composite network of conserved and tissue specific
gene interactions reveals possible genetic interactions in glioma'
In: \emph{PLOS Computational Biology} 13(9): e1005739.
(doi: \url{https://doi.org/10.1371/journal.pcbi.1005739})
}
