# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Extract indecies corresponding to the largest elements
#' @description Extracts the indecies of the \eqn{n} largest elements of the input.
#' This procedure is equivalent to \code{order(x, decreasing = TRUE)[1:n_elements]},
#' but is much faster and avoids the overhead of sorting discarded elements.
#' This function is useful for extracting the rows in a data frame having the
#' largest values in one of the columns.
#' @param x Numeric vector, the vector containing the numbers to sort.
#' @param n_elements Integer scalar, the number of indecies to return.
#' @return Numeric vector, the indecies of the largest elements (in sorted order) in
#' \code{x}.
#' @examples
#' x <- c(10L,5L,-2L,12L,15L)
#' max_indecies <- partial_argsort(x,3L)
#' max_indecies
#' x[max_indecies]
#' order(x)[1:3]
#' mtcars[partial_argsort(mtcars$hp,5L),]
#' @export 
partial_argsort <- function(x, n_elements) {
    .Call(`_csdR_partial_argsort`, x, n_elements)
}

summarizeResults <- function(res_1, res_2, n_threads) {
    .Call(`_csdR_summarizeResults`, res_1, res_2, n_threads)
}

welford_update <- function(mu, var, cor_matrix, iteration, n_threads) {
    .Call(`_csdR_welford_update`, mu, var, cor_matrix, iteration, n_threads)
}

