% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plotSummary}
\alias{plotSummary}
\title{plots boxplots of the max. enhancer prediction values of the enhancers in the condition-specific clusters}
\usage{
plotSummary(D, num_plots = 9)
}
\arguments{
\item{D}{The getDynamics() output file of containing the GRanges object with the differential enhaners}

\item{num_plots}{Maximal number of clusters whose plots should be displayed (clusters are sorted by their sizes). 
This parameter can be set in case the number of clusters is very high. Default is 9.}
}
\value{
ggplot2 object containing a boxplot for each cluster
}
\description{
This functions provides an easy way to get an overview of the differential enhancer clusters that were 
identified in the getDynamics step. The boxplots depict the maximum enhancer probabilities within each enhancer region
in the cluster. By examining the the distribution of predicted enhancer activties, the user can gain more insight into
the clusters.
}
\examples{
#get the output of getDynamics()
files <- c(system.file('extdata', 'Condition1.H3K4me1.bam', package='crupR'),
           system.file('extdata', 'Condition1.H3K4me3.bam', package='crupR'),
           system.file('extdata', 'Condition1.H3K27ac.bam', package='crupR'),
           system.file('extdata', 'Condition2.H3K4me1.bam', package='crupR'),
           system.file('extdata', 'Condition2.H3K4me3.bam', package='crupR'),
           system.file('extdata', 'Condition2.H3K27ac.bam', package='crupR'))
inputs <- rep(system.file('extdata', 'Condition1.Input.bam', package='crupR'), 3)
inputs2 <- rep(system.file('extdata', 'Condition2.Input.bam', package='crupR'), 3)  
metaData <- data.frame(HM = rep(c('H3K4me1', 'H3K4me3', 'H3K27ac'),2),
                       condition = c(1,1,1,2,2,2), replicate = c(1,1,1,1,1,1),
                       bamFile = files, inputFile = c(inputs, inputs2))
dynamics <- readRDS(system.file('extdata', 'differential_enhancers.rds', package='crupR'))
S4Vectors::metadata(dynamics) <- metaData
plotSummary(dynamics)

}
