% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\docType{package}
\name{crupR-package}
\alias{crupR}
\alias{crupR-package}
\title{crupR: Condition-specific Regulatory Units Prediction}
\description{
The crupR package is the re-engineered R package version of the
enhancer prediction pipeline CRUP (Ramisch et. al, 2019). It is designed
to provide a simple pipeline for the analysis and prediction of enhancers using
ChIP-seq experiments of different histone modifications (H3K4me1, H3K4me3, H2K27ac)
as input.
}
\details{
The main functions are:

\itemize{
\item \code{\link{normalize}} - normalize the ChIP-seq data of the three histone modifications by using the input experiment
\item \code{\link{getEnhancers}} - apply the enhancer classifier to the genome-wide, normalized HM counts
\item \code{\link{getDynamics}} - use the genome-wide enhancer predictions to identify condition-specific enhancers
\item \code{\link{getTargets}} - correlate gene expression counts and enhancer activity over different conditions to
find target genes of the enhancers.
\item \code{\link{plotSummary}} - Plot the activity distributions of the condition-specific enhancers identified 
with \code{\link{getDynamics}}
\item \code{\link{getSE}} - summarize the enhancer predictions into enhancer peaks and detect super-enhancers
\item \code{\link{saveFiles}} - export the outputs of the main functions
}

For detailed information on usage, see the package vignette, by typing
\code{vignette('crupR')}.

The code can be viewed at the GitHub repository:

\url{https://github.com/akbariomgba/crupR}
}
\references{
Ramisch, A., Heinrich, V., Glaser, L.V. et al. 
CRUP: a comprehensive framework to predict condition-specific regulatory units. 
Genome Biol 20, 227 (2019).
\url{ https://doi.org/10.1186/s13059-019-1860-7}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/akbariomgba/crupR}
  \item Report bugs at \url{https://github.com/akbariomgba/crupR/issues}
}

}
\author{
Persia Akbari Omgba, Verena Laupert, Martin Vingron
}
\keyword{crupR}
