% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queryTxObject.R
\name{queryTxObject}
\alias{queryTxObject}
\title{Convenience function to search for gene coordinates.}
\usage{
queryTxObject(
  txObject,
  featureType = c("transcripts", "exons", "cds", "fiveUTRs", "threeUTRs", "introns"),
  queryColumn,
  queryValue
)
}
\arguments{
\item{txObject}{A \linkS4class{TxDb} object or a \linkS4class{GRangesList}
object obtained using \code{\link{TxDb2GRangesList}}.}

\item{featureType}{The genomic feature in \code{txObject} to base your
query on. Must be one of the following: "transcripts", "exons", "cds",
"fiveUTRs", "threeUTRs" or "introns".}

\item{queryColumn}{Character string specifying the column in 
\code{txObject[[featureType]]} to search for \code{queryValue}(s).}

\item{queryValue}{Vector specifying the value(s) to search for in
\code{txObject[[featureType]][[queryColumn]]}.}
}
\value{
A \linkS4class{GRanges} object. Searches yielding no results will
    return an empty \linkS4class{GRanges} object.
}
\description{
Convenience function to search for gene coordinates.
}
\examples{

data(grListExample, package="crisprDesign")
queryTxObject(grListExample,
              featureType="cds",
              queryColumn="gene_symbol",
              queryValue="IQSEC3")

}
\seealso{
\code{\link{queryTss}} for querying TSS annotations.
}
\author{
Luke Hoberecht, Jean-Philippe Fortin
}
