% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getConsensusIsoform.R
\name{getConsensusIsoform}
\alias{getConsensusIsoform}
\title{Get the genomic ranges of a consensus isoform}
\usage{
getConsensusIsoform(gene_id, txObject)
}
\arguments{
\item{gene_id}{String specifiying Ensembl ID for the 
gene of interest. E.g. "ENSG00000049618". ID must be present in 
\code{txObject$exons$gene_id}.}

\item{txObject}{A \linkS4class{TxDb} object or a
\linkS4class{GRangesList} object obtained using
\code{\link{TxDb2GRangesList}} to provide a 
gene model annotation.}
}
\value{
A \code{GRanges} object.
}
\description{
Get the genomic ranges of a consensus isoform. 
    The consensus isoform is taken as the union of exons across
    all isoforms where overlapping exons are merged to produce
    a simplified set through the \code{reduce} method of the
    \code{GenomicRanges} package.
}
\examples{
data(grListExample)
gene_id <- "ENSG00000120645"
gr <- getConsensusIsoform(gene_id, grListExample)

}
\author{
Jean-Philippe Fortin
}
